/* Time-delay routine include stuff.
 *
 * Auspice Services is copyright (c) 2000-2001 In Mean
 *     E-mail: auspice@auspice.org
 *
 * SirvNET Services is copyright (c) 1998-2000 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * Originally based on EsperNet Services(c) by Andy Church.
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 */

#ifndef TIMEOUT_H
#define TIMEOUT_H

#include <time.h>

/* Definitions for timeouts: */
typedef struct timeout_ Timeout;
struct timeout_ {
    Timeout *next, *prev;
    NickInfo *ni;
    time_t settime, timeout;
    int repeat;			/* Does this timeout repeat indefinitely? */
    void (*code)(Timeout *);	/* This structure is passed to the code */
    void *data;			/* Can be anything */
    int type;
};


/* Check the timeout list for any pending actions. */
E void check_timeouts(void);

/* Add a timeout to the list to be triggered in `delay' seconds.  Any
 * timeout added from within a timeout routine will not be checked during
 * that run through the timeout list.
 */

E Timeout *add_timeout(int delay, void (*code)(Timeout *), int repeat);

/* Remove a timeout from the list (if it's there). */
E void del_timeout(Timeout *t);


#endif	/* TIMEOUT_H */
