/*
 * Auspice Services is copyright (c) 2000-2001 In Mean
 *  http://www.auspice.org
 * Originally based on SirvNET Services(c) by Trevor Klingbeil.
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 */

#include "../inc/services.h"

Channel *chanlist = NULL;

#ifdef SJOIN
static int smembers = 1;
static int ssize = 0;
static int schans = 0;

static struct sjoin_list {
   char *nick;
} *slist = NULL;
static void extract_nicks();
void get_sjoin_list(char *list, int newchan);
static void add_suser(char *nick, char *channel, User *user, Channel *chan);
static void chan_delete(Channel *c);
#endif

#ifdef SJOIN
/*************************************************************************/
void load_sjoin_mem()
{
       slist = smalloc(sizeof(*slist) * 1024);
       ssize = 1024;
}
/*************************************************************************/
/*
SJOIN:
	av[0]	Time
	av[1]	chan
	av[2]	mode or +
	av[3]	none
	av[4]	cmodenick
SJ3
	av[2]	Mode || User
	av[3]	user || Null
*/
void do_sjoin(char *source, int ac, char **av)
{
   Channel *chan;
   int sf = 0;
   char *s, *nick, *t;
   char *mv[3];
   int args = 0, start = 4;
   int newchan = 0, x = 0;
   int modecnt;
   User *user;

#if defined(RAGEIRCD) || defined(UNREAL)
	sf = 1; /* 4 */
#endif
#ifdef BAHAMUT
	sf = 0; /* 5 */
#endif
   chan = findchan(av[2-sf]);

   if (!chan) {
      if (debug)
           log("Creating new channel %s via sjoin", av[2-sf]);

      chan = scalloc(sizeof(Channel), 1);
      chan->next = chanlist;
      if (chanlist)
          chanlist->prev = chan;
      chanlist = chan;
      strscpy(chan->name, av[2-sf], sizeof(chan->name));
      chan->creation_time = CTime;
      chan->ngames = 1;
      chan->wgames = 1;
      newchan = 1;
   }

#ifdef RAGEIRCD
   sf = 0;
#endif

   if (*av[3-sf] != '+' && *av[3-sf] != '-') {
#ifdef SJ3
      start = start - 1;
#endif
      goto skipmodes;
   }

   if (!stricmp(av[3-sf], "0"))
      goto skipmodes;

   s = av[3-sf];
   strscpy(chan->modes, changemode(s, chan->modes), sizeof(chan->modes));
   while (*s) {
        switch(*s++) {
            case 'l':
                if (chan->limit > 0)
                   chan->limit = 0;
                chan->limit = atoi(av[start-sf]);
//		log("mode +l %s via SJOIN in channel %s", av[start-sf], chan->name);
		start++;
                args++;
                break;
            case 'k':
                if (chan->key) {
                   free(chan->key);
                   chan->key = NULL;
                }
                chan->key = sstrdup(av[start-sf]);
//		log("mode +k %s via SJOIN in channel %s", av[start-sf], chan->name);
		start++;
                args++;
                break;
#ifdef UNREAL
            case 'f':
                if (chan->flood) {
                   free(chan->flood);
                   chan->flood = NULL;
                }
//		log("mode +f %s via SJOIN in channel %s", av[start-sf], chan->name);
                chan->flood = sstrdup(av[start-sf]);
		start++;
                args++;
                break;
            case 'L':
                if (chan->link) {
                   free(chan->link);
                   chan->link = NULL;
                }
//		log("mode +L %s via SJOIN in channel %s", av[start-sf], chan->name);
                chan->link = sstrdup(av[start-sf]);
		start++;
                args++;
                break;
#endif
        }
   }

skipmodes:

   check_modes(chan->name, source);

//   start = start - 1;

   mv[0] = sstrdup(chan->name);
   get_sjoin_list(av[start-sf], newchan);
   for (x = 0; x < smembers; x++) {
 	 char modebuf2[7] = { 0 };
	 t = slist[x].nick;
	 while (*(nick = t)) {
	        t = nick + strcspn (nick, " ");
	        if (*t)
	            *t++ = 0;

	        modecnt = 0;
	        modebuf2[0] = '+';

		while (*nick == '@' || *nick == '+' || *nick == '%' || *nick == '*' || *nick == '~')
		{
			switch (*nick)
			{
			case '@':
		                modecnt++;
                	        modebuf2[modecnt] = 'o';
		                break;
                	case '+':
	                        modecnt++;
             	                modebuf2[modecnt] = 'v';
	                        break;
                	case '%':
	                        modecnt++;
             	                modebuf2[modecnt] = 'h';
	                        break;
                	case '*':
	                        modecnt++;
             	                modebuf2[modecnt] = 'q';
	                        break;
                	case '~':
	                        modecnt++;
             	                modebuf2[modecnt] = 'a';
	                        break;
		        }
	        	nick++;
	     	} /* mode */

	     if (*nick != '&' && *nick !='"') {
		     user = finduser(nick);
		     if (user) {
	        	     mv[2] = sstrdup(user->nick);
	        	     add_suser(mv[2], mv[0], user, chan);
			     check_welcome(user, chan->name);
			     free(mv[2]);
			     checkmass_shouldop(user, chan->name, modebuf2);

	        	     check_kick(user, chan->name);
	        	     check_invite(user, chan->name);
		     } else {
			     log("Try sjoin nonexist user %s", nick);
		     } /* user */
	     } else {
		     if (*nick == '&') {
			char *avs[3];
			avs[0] =  chan->name;
			avs[1] = "+b";
			*nick = *nick++;
			avs[2] = sstrdup(nick);
			do_cmode(s_ChanServ, 3, avs);
			free(avs[2]);
//			log("add ban %s via SJOIN in channel %s", nick, chan->name);
		     }	
	     } /* Ban and ban exception */

	 } /* each nick */
   }
   free(mv[0]);

   for (x = 0; x < smembers; x++) free(slist[x].nick);

   if (newchan) {
            restore_topic(chan->name, chan);
	    if (!chan->havebot)
		    botjoin(chan->name);
	    do_cs_join(chan->name);
   }
}

/*************************************************************************/
void get_sjoin_list(char *list, int newchan)
{
    char *tmp = strtok(list, " ");
    smembers = 1;

    slist[0].nick = sstrdup(tmp);
    if (newchan)
      ++schans;

    extract_nicks();
}
/*************************************************************************/

void extract_nicks()
{
   char *tmp;
   int i = 1;

   while ((tmp = strtok(NULL, " ")) != NULL)
   {
       slist[i++].nick = sstrdup(tmp);
   }
   smembers = i;
  
}

#endif /* If SJOIN */
/*************************************************************************/

/* Return statistics.  Pointers are assumed to be valid. */

void get_channel_stats(long *nrec, long *memuse)
{
    long count = 0, mem = 0;
    Channel *chan;
    struct c_userlist *cu;
    BanData *bd;
    int i;

    for (chan = chanlist; chan; chan = chan->next) {
	count++;
	mem += sizeof(*chan);
	if (chan->topic)
	    mem += strlen(chan->topic)+1;
	if (chan->key)
	    mem += strlen(chan->key)+1;
	if (chan->flood)
	    mem += strlen(chan->flood)+1;
	if (chan->link)
	    mem += strlen(chan->link)+1;
	if (chan->wgame)
	    mem += strlen(chan->wgame)+1;
	mem += sizeof(char *) * chan->bansize;
	for (i = 0; i < chan->bancount; i++) {
	    if (chan->bans[i])
		mem += strlen(chan->bans[i])+1;
	}
	for (cu = chan->users; cu; cu = cu->next) {
            if (cu->ud) {
                mem += sizeof(*cu->ud);
               if (cu->ud->lastline) mem += strlen(cu->ud->lastline)+1;
            }
	 	mem += sizeof(*cu);
	}
        for (bd = chan->bd; bd; bd = bd->next)
        {
                if (bd->mask) mem += strlen(bd->mask)+1;
                mem+= sizeof(*bd);
        }

    }
    *nrec = count;
    *memuse = mem;
}

/*************************************************************************/

/* Return the Channel structure corresponding to the named channel, or NULL
 * if the channel was not found. */

Channel *findchan(const char *chan)
{
    Channel *c = chanlist;

    while (c) {
	if (stricmp(c->name, chan) == 0)
	    return c;
	c = c->next;
    }
    return NULL;
}
/*************************************************************************/
int has_chan_status(User *u, Channel *c, int status)
{
        struct u_chanlist *uc;

        if (!u || !c) return 0;

        for (uc = u->chans; uc; uc = uc->next)
                if (uc->chan == c)
                        return (uc->status & status);

        return 0;
}
/***********************************************************************/
void remove_chan_status(User *u, Channel *c, int status)
{
        struct u_chanlist *uc;

        if (!u || !c) return;

        for (uc = u->chans; uc; uc = uc->next) {
                if (uc->chan == c) {
                        uc->status &= ~status;
                        break;
                }
        }
}
/***********************************************************************/
void set_chan_status(User *u, Channel *c, int status)
{
        struct u_chanlist *uc;

        if (!u || !c) return;
        for (uc = u->chans; uc; uc = uc->next) {
                if (uc->chan == c) {
                        uc->status |= status;
                        break;
                }
        }
}

/*************************************************************************/
/* Add/remove a user to/from a channel, creating or deleting the channel as
 * necessary. */
void chan_adduser(User *user, const char *chan)
{
#ifndef BAHSJOIN
    Channel *c = findchan(chan);
    struct c_userlist *u;
    int newchan = !c;

    if (newchan) {
	if (debug)
	    log("debug: Creating channel %s", chan);
	/* Allocate pre-cleared memory */

	c = scalloc(sizeof(Channel), 1);
	c->next = chanlist;
	if (chanlist)
	    chanlist->prev = c;
	chanlist = c;
	strscpy(c->name, chan, sizeof(c->name));
	c->creation_time = CTime;
	/* This will restore locked modes and saved topic */
        check_invite(user, chan);
	check_modes(chan,user->nick);
	restore_topic(chan, c);
	botjoin(c->name);
        do_cs_join(chan);
    }
#endif

#ifndef BAHSJOIN
    u = scalloc(sizeof(struct c_userlist),1);
    u->next = c->users;
    u->prev = NULL;
    if (c->users)
	c->users->prev = u;
    c->users = u;
    u->user = user;
    u->ud = scalloc(sizeof(UserData), 1);
    u->ud->last_use = CTime;
    c->usercount++;
#endif
}

void chan_deluser(User *user, Channel *c)
{
    struct c_userlist *u;
    struct c_userlist *u2;

    if (!user || !c)
       return;

    u2 = c->users;
    if (!u2)
      return;

    for (u = c->users; u && u->user != user; u = u->next)
        ;
    if (!u)
	return;

    if (u->ud)
    {
        if (u->ud->lastline) {
                free(u->ud->lastline);
	}
        free(u->ud);
    }

    if (u->next)
	u->next->prev = u->prev;
    if (u->prev)
	u->prev->next = u->next;
    else
	c->users = u->next;
    free(u);

}
/*************************************************************************/

/* Handle a channel MODE command. */

void do_cmode(const char *source, int ac, char **av)
{
    Channel *chan;
    User *user;
    char *s, *nick;
    int add = 1, recheck = 0;		/* 1 if adding modes, 0 if deleting */
    char *modestr = av[1];
    chan = findchan(av[0]);

    if (!chan) {
	log("channel: MODE %s for nonexistent channel %s",
                                     merge_args(ac-1, av+1), av[0]);
	return;
    }

    if (strchr(source, '.') && !modestr[strcspn(modestr, cmodeless)]) {
        if (CTime != chan->server_modetime) {
            chan->server_modecount = 0;
            chan->server_modetime = CTime;
        }
        chan->server_modecount++;
    }

    s = modestr;
    ac -= 2;
    av += 2;
   
    while (*s) {

	switch (*s++) {

	case '+':
	    add = 1; break;

	case '-':
	    add = 0; break;

	case 'k':
	    if (add) {
			if (chan->key) {
				free(chan->key);
				chan->key = NULL;
  			}
			chan->key = sstrdup(*av++);
	    }
	    recheck = 1;
	    break;

	case 'l':
	    if (add) {
			chan->limit = atoi(*av++);
	    } else {
			chan->limit = 0;
	    }
 	    recheck = 1;

	    break;

#ifdef UNREAL
        case 'L':
            if (--ac < 0) {
                log("channel: MODE %s %s: missing parameter for %cL",
                                        chan->name, modestr, add ? '+': '-');
                break;
            }
            if (add && *av) {
	        if (chan->link) {
		        free(chan->link);
		        chan->link = NULL;
		}
		chan->link = sstrdup(*av++);

	    }
 	    recheck = 1;

            break;
#endif
#if defined(UNREAL)  || defined(ULTIMATE)
        case 'f':
            if (--ac < 0) {
                log("channel: MODE %s %s: missing parameter for %cf",
                                        chan->name, modestr, add ? '+': '-');
                break;
            }

            if (add && *av) {
		if (chan->flood) {
	                free(chan->flood);
	                chan->flood = NULL;
                }
	                chan->flood = sstrdup(*av++);
		}
 	    recheck = 1;

		break;
#endif
	case 'b':
	    if (--ac < 0) {
		log("channel: MODE %s %s: missing parameter for %cb",
					chan->name, modestr, add ? '+' : '-');
		break;
	    }
	    if (add) {
		if (chan->bancount >= chan->bansize) {
		    chan->bansize += 8;
		    chan->bans = srealloc(chan->bans,
					sizeof(char *) * chan->bansize);
		}
		chan->bans[chan->bancount++] = sstrdup(*av++);
		checktban(chan);
	    } else {
		char **s1 = chan->bans;
		int i = 0;
		while (i < chan->bancount && strcmp(*s1, *av) != 0) {
		    ++i; ++s1;
		}
		if (i < chan->bancount) {
		    --chan->bancount;
		    if (i < chan->bancount)
			bcopy(s1+1, s1, sizeof(char *) * (chan->bancount-i));
		}
		deltban(chan, *av);
		++av;
		checktban(chan);
	    }

	    break;
	case 'o':
	    checktban(chan);
	    if (--ac < 0) {
		log("channel: MODE %s %s: missing parameter for %co",
					chan->name, modestr, add ? '+' : '-');
		break;
	    }
	    nick = *av++;
	    if (add) {
		user = finduser(nick);
		if (!user) {
		    log("channel: MODE %s +o for nonexistent user %s",
							chan->name, nick);
		    break;
		}

		if (debug)
		    log("debug: Setting +o on %s for %s", chan->name, nick);

		set_chan_status(user, chan, CSTATUS_OP);
	    } else {
		user = finduser(nick);
		if (!user)
			break;
		remove_chan_status(user, chan, CSTATUS_OP);
	    }

	    break;
#ifdef DEFHALFOP
	case 'h':
	    if (--ac < 0) {
		log("channel: MODE %s %s: missing parameter for %ch",
					chan->name, modestr, add ? '+' : '-');
		break;
	    }
	    checktban(chan);
	    nick = *av++;
	    if (add) {
		user = finduser(nick);
		if (!user) {
		    log("channel: MODE %s +h for nonexistent user %s",
							chan->name, nick);
		    break;
		}
		if (debug)
		    log("debug: Setting +h on %s for %s", chan->name, nick);
		set_chan_status(user, chan, CSTATUS_HALFOP);
	    } else {
		user = finduser(nick);
		if (!user)
			break;
		remove_chan_status(user, chan, CSTATUS_HALFOP);
	    }
	    break;
#endif
	case 'v':
	    checktban(chan);
	    if (--ac < 0) {
		log("channel: MODE %s %s: missing parameter for %cv",
					chan->name, modestr, add ? '+' : '-');
		break;
	    }
	    nick = *av++;
	    if (add) {
		user = finduser(nick);
		if (!user) {
		    log("channel: MODE %s +v for nonexistent user %s",
							chan->name, nick);
		    break;
		}
		if (debug)
		    log("debug: Setting +v on %s for %s", chan->name, nick);
		set_chan_status(user, chan, CSTATUS_VOICE);
	    } else {
		user = finduser(nick);
		if (!user)
			break;
		remove_chan_status(user, chan, CSTATUS_VOICE);
	    }
	    break;
#ifdef UNREAL
	case 'q':
	    if (--ac < 0) {
		log("channel: MODE %s %s: missing parameter for %cq",
					chan->name, modestr, add ? '+' : '-');
		break;
	    }
	    nick = *av++;
	    if (add) {
		user = finduser(nick);
		if (!user) {
		    log("channel: MODE %s +q for nonexistent user %s",
							chan->name, nick);
		    break;
		}
		if (debug)
		    log("debug: Setting +q on %s for %s", chan->name, nick);

                if (!check_valid_op(user, chan->name, !!strchr(source, '.'))) {
                       send_cmd(s_ChanServ, "MODE %s -q %s", chan->name, nick);
                       break;
                } else {
		set_chan_status(user, chan, CSTATUS_OWNER);
		}
	    } else {
		user = finduser(nick);
		if (!user)
			break;
		remove_chan_status(user, chan, CSTATUS_OWNER);
	    }
	    break;
#endif
#ifdef DEFPROTECT
#if defined(UNREAL) || defined(RAGEIRCD) || defined(ULTIMATE)
	case 'a':
#elif defined(LIQUID)
	case 'u':
#endif
	    if (--ac < 0) {
			log("channel: MODE %s %s: missing parameter for %ca",
					chan->name, modestr, add ? '+': '-');
			break;
	    }
	    nick = *av++;
	    if (add) {
			user = finduser(nick);
		if (!user) {
		    log("channel: MODE %s +a for nonexistent user %s",
							chan->name, nick);
		    break;
		}
		if (debug)
		    log("debug: Setting +a on %s for %s", chan->name, nick);

                if (!check_valid_op(user, chan->name, !!strchr(source, '.'))) {
#ifdef UNREAL
                       send_cmd(s_ChanServ, "MODE %s -a %s", chan->name, nick);
#endif
#if defined(LIQUID) || defined(RAGEIRCD)
                       send_cmd(s_ChanServ, "MODE %s -u %s", chan->name, nick);
#endif
                       break;
                } else {
		set_chan_status(user, chan, CSTATUS_PROTECT);
		}
	    } else {
		user = finduser(nick);
		if (!user)
			break;
		remove_chan_status(user, chan, CSTATUS_PROTECT);
	    }
	    break;
#endif /* If DEFINE PRO */
	default:
 	    recheck = 1;

	} /* switch */

    } /* while (*s) */

/* Merge chan->modes and modestr */
    strscpy(chan->modes, changemode(modestr, chan->modes), sizeof(chan->modes));

/* Merge remove some cmode from chan->modes like a o h v... */
    strscpy(chan->modes, changemode(cmodeless, chan->modes), sizeof(chan->modes));

    /* Check modes against ChanServ mode lock */

    if (!is_servbot(source) && recheck)
         check_modes(chan->name, source);
}

/*************************************************************************/

/* Handle a TOPIC command. */

void do_topic(const char *source, int ac, char **av)
{
    Channel *c = findchan(av[0]);

    if (!c)
	return;
    
    strscpy(c->topic_setter, av[1], sizeof(c->topic_setter));

    c->topic_time = atol(av[2]);

    if (ac > 3 && *av[3]) {
	if (c->topic)
		free(c->topic);
	c->topic = sstrdup(av[3]);

    }
    if (!strchr(source, '.')) {
        if (check_topiclock(source, av[0])) {
            return;
	}
	record_topic(av[0], c);
    } else {
	return;
    }
}

/*************************************************************************/

/* Does the given channel have only one user? */

/* Note:  This routine is not currently used, but is kept around in case it
 * might be handy someday. */

//#if 0

int only_one_user(const char *chan)
{
    Channel *c;

    for (c = chanlist; c; c = c->next) {
	if (stricmp(c->name, chan) == 0)
	    return (c->users && !c->users->next) ? 1 : 0;
    }
    return 0;
}

//#endif

int isin_chan(char *nick, const char *chan)
{
    Channel *c;
    struct c_userlist *cu;

    for (c = chanlist; c; c = c->next) {
        if (stricmp(c->name, chan) == 0) {
	    for (cu = c->users; cu; cu = c->users->next) {
		if (stricmp(cu->user->nick, nick) == 0)
		    return 1;
	    }
	    return 0;
	}
    }
    return 0;
}
/*************************************************************************/
int channel_form()
{
    Channel *c;
    int i = 0;
    for (c = chanlist; c; c = c->next)
	i++;
    return i;
}
/*************************************************************************/
void change_cmode (const char *who, const char *chan, const char *mode, const char *pram)
{
    char *av[3];
    av[0] = sstrdup (chan);
    av[1] = sstrdup (mode);
    av[2] = sstrdup (pram);
    send_cmd (who, "MODE %s %s %s", chan, mode, pram);
    do_cmode (who, 3, av);
    free (av[2]);
    free (av[1]);
    free (av[0]);
}
/****************************************************/
void kick_user (const char *who, const char *chan, const char *nick, const char *reason)
{
    char *av[3];
    av[0] = sstrdup (chan);
    av[1] = sstrdup (nick);
    av[2] = sstrdup (reason);
    send_cmd (who, "KICK %s %s :%s", chan, nick, reason);
    do_kick (who, 3, av);
    free (av[2]);
    free (av[1]);
    free (av[0]);
}
/***************************************************/
#ifdef SJOIN
static void add_suser(char *nick, char *channel, User *user, Channel *chan)
{
   struct c_userlist *u;
   struct u_chanlist *c;

   chan->usercount++;

      u = scalloc(sizeof(struct c_userlist),1);
      u->next = chan->users;
      u->prev = NULL;
      if (chan->users)
         chan->users->prev = u;
      chan->users = u;
      u->user = user;
      u->ud = scalloc(sizeof(UserData), 1);
      u->ud->last_use = CTime;

      c = scalloc(sizeof(*c),1);
      c->next = user->chans;
      c->prev = NULL;
      if (user->chans)
          user->chans->prev = c;
      user->chans = c;
      c->chan = findchan(chan->name);

}
#endif
/***************************************************************/
char *filter_modes (char *chan, char *on, char *off)
{
    Channel *c = findchan (chan);
    ChannelInfo *ci = cs_findchan (chan);
    char *current = c->modes;
    char new_on[64];
    char new_off[64];
    char filtered[64];

    if (!c || !ci)
        return NULL;

    *filtered = *new_on = *new_off = 0;

    if (strchr (on, 'c') && !strchr (current, 'c') && !strchr (off, 'c'))
        strcat (new_on, "c");
    if (strchr (off, 'c') && strchr (current, 'c') && !strchr (on, 'c'))
        strcat (new_off, "c");

    if (strchr (on, 'i') && !strchr (current, 'i') && !strchr (off, 'i'))
        strcat (new_on, "i");
    if (strchr (off, 'i') && strchr (current, 'i') && !strchr (on, 'i'))
        strcat (new_off, "i");

    if (strchr (on, 'k') && !strchr (current, 'k') && !strchr (off, 'k'))
        strcat (new_on, "k");
    if (strchr (off, 'k') && strchr (current, 'k') && !strchr (on, 'k'))
        strcat (new_off, "k");


    if (strchr (on, 'l') && !strchr (current, 'l') && !strchr (off, 'l'))
        strcat (new_on, "l");
    if (strchr (off, 'l') && strchr (current, 'l') && !strchr (on, 'l'))
        strcat (new_off, "l");


    if (strchr (on, 'm') && !strchr (current, 'm') && !strchr (off, 'm'))
        strcat (new_on, "m");
    if (strchr (off, 'm') && strchr (current, 'm') && !strchr (on, 'm'))
        strcat (new_off, "m");


    if (strchr (on, 'n') && !strchr (current, 'n') && !strchr (off, 'n'))
        strcat (new_on, "n");
    if (strchr (off, 'n') && strchr (current, 'n') && !strchr (on, 'n'))
        strcat (new_off, "n");

    if (strchr (on, 'p') && !strchr (current, 'p') && !strchr (off, 'p'))
        strcat (new_on, "p");
    if (strchr (off, 'p') && strchr (current, 'p') && !strchr (on, 'p'))
        strcat (new_off, "p");

    if (strchr (on, 'r') && !strchr (current, 'r') && !strchr (off, 'r'))
        strcat (new_on, "r");
    if (strchr (off, 'r') && strchr (current, 'r') && !strchr (on, 'r'))
        strcat (new_off, "r");


    if (strchr (on, 'R') && !strchr (current, 'R') && !strchr (off, 'R'))
        strcat (new_on, "R");
    if (strchr (off, 'R') && strchr (current, 'R') && !strchr (on, 'R'))
        strcat (new_off, "R");

    if (strchr (off, 's') && strchr (current, 's') && !strchr (on, 's'))
        strcat (new_off, "s");
    if (strchr (on, 's') && !strchr (current, 's') && !strchr (off, 's'))
        strcat (new_on, "s");

    if (strchr (on, 't') && !strchr (current, 't') && !strchr (off, 't'))
        strcat (new_on, "t");
    if (strchr (off, 't') && strchr (current, 't') && !strchr (on, 't'))
        strcat (new_off, "t");

    if (strlen (new_on))
    {
        strcat (filtered, "+");
        strcat (filtered, new_on);
    }
    if (strlen (new_off))
    {
        strcat (filtered, "-");
        strcat (filtered, new_off);
    }
    if (ci->mlock_limit && c->limit != ci->mlock_limit)
        if (strlen (new_on))
            if (strchr (new_on, 'l'))
            {
                strcat (filtered, " ");
                strcat (filtered, myitoa(ci->mlock_limit));
            }
    if (ci->mlock_key && (!c->key || !strcmp (c->key, ci->mlock_key)))
        if (strlen (new_on))
            if (strchr (new_on, 'k'))
            {
                strcat (filtered, " ");
                strcat (filtered, ci->mlock_key);
            }
    if (strlen (new_off))
        if (strchr (new_off, 'k'))
        {
            strcat (filtered, " ");
            strcat (filtered, c->key);
        }
    if (strlen (filtered))
        change_cmode (s_ChanServ, c->name, filtered, "");

    return NULL;
}

/***************************************************/
void deltban(Channel *c, char *mask) {
    BanData *bd, *next;
    for (bd = c->bd; bd; bd = next) {
	if (!stricmp(bd->mask, mask)) {
	        log("Clear tban in %s %s", c->name, mask);
		if (bd->next)
			bd->next->prev = bd->prev;
		if (bd->prev)
			bd->prev->next = bd->next;
		else
			c->bd = bd->next;
		if (bd->mask) {
			free(bd->mask);
		}
		next = bd->next;
                free(bd);
		continue;
	} /* If */
	next = bd->next;
    }
}
void checktban(Channel *c) {
    BanData *bd, *next;
    time_t now = time(NULL);
    for (bd = c->bd; bd; bd = next) {
	if (now - bd->last_use > (bd->banmin * 60))
        {
		if (bd->next)
			bd->next->prev = bd->prev;
		if (bd->prev)
			bd->prev->next = bd->next;
		else
			c->bd = bd->next;
		if (bd->mask) {
			send_cmd(s_ChanServ, "%s %s -b %s", 
			istoken?TOK_MODE:MSG_MODE, c->name, bd->mask);
			free(bd->mask);
		}
		next = bd->next;
                free(bd);
		continue;
	} /* If */
	next = bd->next;
    }
}

void addtban(Channel *c, char *mask, int mins, char *who) {

    BanData *bd, *next;
    time_t now = time(NULL);

    for (bd = c->bd; bd; bd = next) {
	if (!stricmp(bd->mask, mask))
	{
		bd->last_use = now;
		return;
	}
	next = bd->next;
    }
    send_cmd (who, "MODE %s +b %s", c->name, mask);
    bd = scalloc(sizeof(BanData), 1);
    bd->mask = sstrdup(mask);
    bd->last_use = now;
    bd->banmin = mins;

    bd->prev = NULL;
    bd->next = c->bd;
    if (bd->next) bd->next->prev = bd;
    c->bd = bd;
    checktban(c);
}
