/* HelpServ functions.
 *
 * Auspice Services is copyright (c) 2000-2001 In Mean
 *     E-mail: auspice@auspice.org
 * SirvNET Services is copyright (c) 1998-2000 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * Originally based on EsperNet Services(c) by Andy Church.
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 */

#include "../inc/services.h"
#include <sys/stat.h>

static void do_help(const char *whoami, const char *source, char *topic);

/*************************************************************************/

/* helpserv:  Main HelpServ routine.  `whoami' is what nick we should send
 * messages as: this won't necessarily be s_HelpServ, because other
 * routines call this one to display help files. */

void helpserv(const char *whoami, const char *source, char *buf)
{
    char *cmd, *topic, *s;

    topic = buf ? sstrdup(buf) : NULL;
    cmd = strtok(buf, " ");
    if (cmd && stricmp(cmd, "\1PING") == 0) {
	if (!(s = strtok(NULL, "")))
	    s = "\1";
	notice(s_HelpServ, source, "\1PING %s", s);
    } else if (cmd && stricmp(cmd, "SMARTREPORT") == 0) {
	 m_smartinfo(source);
    } else {
	 do_help(whoami, source, topic);
    }
    if (topic)
	free(topic);
}

/*************************************************************************/
/*********************** HelpServ command routines ***********************/
/*************************************************************************/

/* Return a help message. */

static void do_help(const char *whoami, const char *source, char *topic)
{
    FILE *f;
    struct stat st;
    char buf[256], *ptr, *s;
    char *old_topic;	/* an unclobbered (by strtok) copy */

    if (!topic || !*topic)
	topic = "help";
    	old_topic = sstrdup(topic);
    if (stricmp(topic, "AUSPICE") == 0) {
        notice(whoami, source,
            "Auspice Services are Copyright (c) 2000-2001 In Mean");
        notice(whoami, source, "Website: \2http://www.auspice.org\2");
        notice(whoami, source, "FTP: \2ftp://auspice.sourceforge.net\2");
        notice(whoami, source, "Auspice Services written by In Mean <auspice@auspice.org>");
        notice(whoami, source, "Thanks to all peoples in credits list:");
        notice(whoami, source, "Type \2/Msg HelpServ CREDITS\2");
   } else if (stricmp(topic, "CREDITS") == 0) {
	m_realcredits(source);
   } else if (stricmp(topic, "INFO") == 0) {
	m_realinfo(source);
   } else {

    /* As we copy path parts, (1) lowercase everything and (2) make sure
     * we don't let any special characters through -- this includes '.'
     * (which could get parent dir) or '/' (which couldn't _really_ do
     * anything if we keep '.' out, but better to be on the safe side).
     * Special characters turn into '_'.
     */
         strscpy(buf, HELPSERV_DIR, sizeof(buf));
         ptr = buf + strlen(buf);
         for (s = strtok(topic, " "); s && ptr-buf < sizeof(buf)-1;
						s = strtok(NULL, " ")) {
            *ptr++ = '/';
            while (*s && ptr-buf < sizeof(buf)-1) {
                if (*s == '.' || *s == '/')
                   *ptr++ = '_';
	    else
                 *ptr++ = tolower(*s);
                 ++s;
            }
            *ptr = 0;
        }
    /* If we end up at a directory, go for an "index" file/dir if
     * possible.
     */
        while (ptr-buf < sizeof(buf)-1
                    && stat(buf, &st) == 0 && S_ISDIR(st.st_mode)) {
            *ptr++ = '/';
            strscpy(ptr, "index", sizeof(buf) - (ptr-buf));
            ptr += strlen(ptr);
        }

        /* Send the file, if it exists.
         */
        if (!(f = fopen(buf, "r"))) {
           if (debug)
                log_perror("debug: Cannot open help file %s", buf);
            notice(whoami, source,
                   "Sorry, no help available for \2%s\2.", old_topic);
           slog("HS *H %s [%s]",
              source, old_topic);
           free(old_topic);
           return;
       }
       while (fgets(buf, sizeof(buf), f)) {
           s = strtok(buf, "\n");
        /* Use this odd construction to prevent any %'s in the text from
	 * doing weird stuff to the output.  Also replace blank lines by
	 * spaces (see send.c/notice_list() for an explanation of why).
	 */
           notice(whoami, source, "%s", s ? s : " ");
       }
       fclose(f);
    }
    free(old_topic);
}
