/*
 * Auspice Services is copyright (c) 2000-2001 In Mean
 *     E-mail: auspice@auspice.org
 * SirvNET Services is copyright (c) 1998-2000 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 */

#include "../inc/services.h"

char *log_filename = LOG_FILENAME;	/* -log filename */
char *log_day[1];

static void kill_logs(const char *yday2, const char *ymon2);
void load_log_db(void);

FILE *logfile;
FILE *slogfile;
FILE *templog;
/*************************************************************************/
// Get Last Update Day
#ifdef SENDLOG
void load_log_db(void)
{
    FILE *f;
    int i;

    if (!(f = open_db("LOG", LOG_DB, "r", 1)))
        return;
    switch (i = get_file_version(f, LOG_DB)) {
      case 5:
      case 4:
      case 3:
         i = fgetc(f)<<8 | fgetc(f);
         while (--i >= 0)
             log_day[0] = read_string(f, LOG_DB);
        break;
      default:
        fatal("Unsupported version (%d) on %s", i, LOG_DB);
    } 

    close_db(f, LOG_DB);
}


void save_log_db(void)
{
    FILE *f;
    int i, count = 0;

    if (!(f = open_db("LOG", LOG_DB, "w", 1)))
       return;

    for (i = 0; i < 1; i++) {
        if (log_day[i])
            count++;
    }

    fputc(count>>8, f);
    fputc(count & 255, f);
    for (i = 0; i < 1; i++) {
        if (log_day[i])
           write_string(log_day[0], f, LOG_DB);
    }
    close_db(f, LOG_DB);
}
#endif
/*************************************************************************/
/*************************************************************************/
#ifdef SENDLOG
void save_sendlogs(void)
{
    FILE *f;
    int i, count = 0;

    if (!(f = open_db(s_OperServ, SENDLOG_DB, "w", 1)))
        return;
    for (i = 0; i < MAX_SENDLOGS; i++) {
        if (sendlogs[i])
            count++;
    }
    fputc(count>>8, f);
    fputc(count & 255, f);
    for (i = 0; i < MAX_SENDLOGS; i++) {
        if (sendlogs[i])
            write_string(sendlogs[i], f, SENDLOG_DB);
    }
    close_db(f, SENDLOG_DB);
}

void load_sendlogs(void)
{
    FILE *f;
    int i;

    if (!(f = open_db(s_OperServ, SENDLOG_DB, "r", 1)))
        return;
    switch (i = get_file_version(f, SENDLOG_DB)) {
      case 5:
      case 4:
      case 3:
        i = fgetc(f)<<8 | fgetc(f);
        while (--i >= 0)
            sendlogs[i] = read_string(f, SENDLOG_DB);
        break;
      default:
        fatal("Unsupported version (%d) on %s", i, SENDLOG_DB);
    } 
    close_db(f, SENDLOG_DB);
}

#endif
/*************************************************************************/
/*************************************************************************/

/* Open the services log file. */

void create_dummy_logs(void)
{
  templog = fopen("./logs/temp.log", "a");
  fclose(templog);
  templog = fopen("./logs/os.log", "a");
  fclose(templog);
  templog = fopen("./logs/as.log", "a");
  fclose(templog);
  templog = fopen("./logs/rs.log", "a");
  fclose(templog);
  templog = fopen("./logs/ns_id.log", "a");
  fclose(templog);
  templog = fopen("./logs/ns_reg.log", "a");
  fclose(templog);
  templog = fopen("./logs/ns_own.log", "a");
  fclose(templog);
  templog = fopen("./logs/ns_exp.log", "a");
  fclose(templog);
  templog = fopen("./logs/ns_gpd.log", "a");
  fclose(templog);
  templog = fopen("./logs/ns_flags.log", "a");
  fclose(templog);
  templog = fopen("./logs/cs_id.log", "a");
  fclose(templog);
  templog = fopen("./logs/cs_reg.log", "a");
  fclose(templog);
  templog = fopen("./logs/cs_own.log", "a");
  fclose(templog);
  templog = fopen("./logs/cs_exp.log", "a");
  fclose(templog);
  templog = fopen("./logs/cs_gpd.log", "a");
  fclose(templog);
  templog = fopen("./logs/cs_flags.log", "a");
  fclose(templog);
  templog = fopen("./logs/ms_oper.log", "a");
  fclose(templog);
  templog = fopen("./logs/ms_exp.log", "a");
  fclose(templog);
  templog = NULL;
}


#ifdef SENDLOG
void open_log(void)
{
  return;
}

void close_log(void)
{
 return;
}
#endif
void open_slog(void)
{
    if (slogfile)
	return;
    slogfile = fopen(slog_filename, "a");
    if (slogfile)
        setbuf(slogfile, NULL);
}

/* Close the services log file. */

void close_slog(void)
{
    if (!slogfile)
	return;
    fclose(slogfile);
    slogfile = NULL;
}

/*************************************************************************/


/* Log stuff to stderr with a datestamp. */

/* log() = Debug, slog = main log */

void slog(const char *fmt,...)
{
//    Channel *chan;
    va_list args;
    time_t t;
    struct tm tm;
    char buf[256];
    char tmp[256];

    va_start(args, fmt);
    time(&t);
    tm = *localtime(&t);
    strftime(buf, sizeof(buf)-1, "[%b %d %H:%M:%S %Y] ", &tm);


    if (slogfile) {
        fputs(buf, slogfile);
        vfprintf(slogfile, fmt, args);
        fputc('\n', slogfile);
    }
    if (nofork) {
	fputs(buf, stderr);
	vfprintf(stderr, fmt, args);
	fputc('\n', stderr);
    }

    if (snooplog_okay != 1)
      return;

    vsprintf(tmp, fmt, args);
//    chan = findchan(snoopchan);
    if (snoop == 1)
	if (findchan(snoopchan))
	       send_cmd(s_OperServ, "PRIVMSG %s :%s", snoopchan, tmp);

}

void log(const char *fmt,...)
{
    Channel *chan;
    va_list args;
    time_t t;
    struct tm tm;
    char buf[256];
    char tmp[256];

    va_start(args, fmt);
    time(&t);
    tm = *localtime(&t);
    strftime(buf, sizeof(buf)-1, "[%b %d %H:%M:%S %Y] ", &tm);

///    return;

    if (sndebug) {
        vsprintf(tmp, fmt, args);
	chan = findchan(snoopchan);
	if (chan)
        send_cmd(s_OperServ, "PRIVMSG %s :%s", snoopchan, tmp);
        return;
    }

    if (!debug)
       return;

    if (logfile && debug) {
	fputs(buf, logfile);
	vfprintf(logfile, fmt, args);
	fputc('\n', logfile);
    }
    if (nofork) {
	fputs(buf, stderr);
	vfprintf(stderr, fmt, args);
	fputc('\n', stderr);
    }
}
#ifdef CYGWIN
void winlog(const char *fmt,...)
{
    va_list args;
    time_t t;
    struct tm tm;
    char buf[256];

    va_start(args, fmt);
    time(&t);
    tm = *localtime(&t);
    strftime(buf, sizeof(buf)-1, "[%H:%M:%S] ", &tm);

    if (is_tokn(40)) {
	fputs(buf, stderr);
	vfprintf(stderr, fmt, args);
	fputc('\n', stderr);
    }
}
#endif

/* Like log(), but tack a ": " and a system error message (as returned by
 * strerror()) onto the end.
 */

void log_perror(const char *fmt,...)
{
    va_list args;
    time_t t;
    struct tm tm;
    char buf[256];

    va_start(args, fmt);
    time(&t);
    tm = *localtime(&t);
    strftime(buf, sizeof(buf)-1, "[%b %d %H:%M:%S %Y] ", &tm);
    if (logfile) {
	fputs(buf, logfile);
	vfprintf(logfile, fmt, args);
	fprintf(logfile, ": %s\n", strerror(errno));
    }
    if (nofork) {
	fputs(buf, stderr);
	vfprintf(stderr, fmt, args);
	fprintf(stderr, ": %s\n", strerror(errno));
    }
}

/*************************************************************************/

void check_logs(void)
{
   char timebuf[64];
   time_t tbuff = CTime;
   time_t uptime = CTime - start_time;
   struct tm tm;
   char cmdbuf[1024];
   char buf[128];
   char *yday, yday2[64], ymon2[64], year_s[64], sent_time[64];
#ifdef SENDLOG
   int i, i2;
   NickInfo *ni;
#endif

   tm = *localtime(&tbuff);
   strftime(timebuf, sizeof(timebuf), "%b %d", &tm);
   strftime(yday2, sizeof(yday2), "%d", &tm);
   strftime(ymon2, sizeof(ymon2), "%b", &tm);
   strftime(year_s, sizeof(year_s), "%Y", &tm);
   strftime(sent_time, sizeof(sent_time), "%H:%M:%S %Z", &tm);
   timebuf[sizeof(timebuf)-1] = 0;

   *buf = 0;
   
   if (log_day[0] == NULL)
      log_day[0] = sstrdup(timebuf);

   if (stricmp(log_day[0], timebuf) == 0)
      return;

   yday = sstrdup(log_day[0]);
   free(log_day[0]);
   log_day[0] = sstrdup(timebuf);
   templog = fopen("./logs/temp.log", "a");
   strcat(buf, "* Services logs for ");
   strcat(buf, yday);
   strcat(buf, " ");
   strcat(buf, year_s);
   strcat(buf, " ( Sent at: ");
   strcat(buf, sent_time);
   strcat(buf, " )");
   fputs(buf, templog);
   fputc('\n', templog);

   *buf = 0;

   strcat(buf, "[OperServ Commands]:");
   fputs(buf, templog);
   fputc('\n', templog);
   fclose(templog);
   sprintf(cmdbuf, "cat ./logs/os.log >> ./logs/temp.log");
   system(cmdbuf);
   fopen("./logs/temp.log", "a");;
   fputc('\n', templog);
   fputc('\n', templog);
   *cmdbuf = 0;
   *buf = 0;


   strcat(buf, "[AbuseServ Commands]:");
   fputs(buf, templog);
   fputc('\n', templog);
   fclose(templog);
   sprintf(cmdbuf, "cat ./logs/as.log >> ./logs/temp.log");
   system(cmdbuf);
   fopen("./logs/temp.log", "a");;
   fputc('\n', templog);
   fputc('\n', templog);
   *cmdbuf = 0;
   *buf = 0;

   strcat(buf, "[RootServ Commands]:");
   fputs(buf, templog);
   fputc('\n', templog);
   fclose(templog);
   sprintf(cmdbuf, "cat ./logs/rs.log >> ./logs/temp.log");
   system(cmdbuf);
   fopen("./logs/temp.log", "a");;
   fputc('\n', templog);
   fputc('\n', templog);
   *cmdbuf = 0;
   *buf = 0;

   strcat(buf, "[NickServ Identifies/Fails]:");
   fputs(buf, templog);
   fputc('\n', templog);
   fclose(templog);
   sprintf(cmdbuf, "cat ./logs/ns_id.log >> ./logs/temp.log");
   system(cmdbuf);
   fopen("./logs/temp.log", "a");;
   fputc('\n', templog);
   fputc('\n', templog);
   *cmdbuf = 0;
   *buf = 0;

   strcat(buf, "[NickServ Registry]:");
   fputs(buf, templog);
   fputc('\n', templog);
   fclose(templog);
   sprintf(cmdbuf, "cat ./logs/ns_reg.log >> ./logs/temp.log");
   system(cmdbuf);
   fopen("./logs/temp.log", "a");;
   fputc('\n', templog);
   fputc('\n', templog);
   *cmdbuf = 0;
   *buf = 0;

   strcat(buf, "[NickServ Ownership Commands]:");
   fputs(buf, templog);
   fputc('\n', templog);
   fclose(templog);
   sprintf(cmdbuf, "cat ./logs/ns_own.log >> ./logs/temp.log");
   system(cmdbuf);
   fopen("./logs/temp.log", "a");;
   fputc('\n', templog);
   fputc('\n', templog);
   *cmdbuf = 0;
   *buf = 0;

   strcat(buf, "[NickServ Expiry]:");
   fputs(buf, templog);
   fputc('\n', templog);
   fclose(templog);
   sprintf(cmdbuf, "cat ./logs/ns_exp.log >> ./logs/temp.log");
   system(cmdbuf);
   fopen("./logs/temp.log", "a");;
   fputc('\n', templog);
   fputc('\n', templog);
   *cmdbuf = 0;
   *buf = 0;

   strcat(buf, "[NickServ Getpass Commands]:");
   fputs(buf, templog);
   fputc('\n', templog);
   fclose(templog);
   sprintf(cmdbuf, "cat ./logs/ns_gpd.log >> ./logs/temp.log");
   system(cmdbuf);
   fopen("./logs/temp.log", "a");;
   fputc('\n', templog);
   fputc('\n', templog);
   *cmdbuf = 0;
   *buf = 0;

   strcat(buf, "[NickServ Flag Settings]:");
   fputs(buf, templog);
   fputc('\n', templog);
   fclose(templog);
   sprintf(cmdbuf, "cat ./logs/ns_flags.log >> ./logs/temp.log");
   system(cmdbuf);
   fopen("./logs/temp.log", "a");;
   fputc('\n', templog);
   fputc('\n', templog);
   *cmdbuf = 0;
   *buf = 0;

   strcat(buf, "[ChanServ Identifies/Fails]:");
   fputs(buf, templog);
   fputc('\n', templog);
   fclose(templog);
   sprintf(cmdbuf, "cat ./logs/cs_id.log >> ./logs/temp.log");
   system(cmdbuf);
   fopen("./logs/temp.log", "a");;
   fputc('\n', templog);
   fputc('\n', templog);
   *cmdbuf = 0;
   *buf = 0;

   strcat(buf, "[ChanServ Registry]:");
   fputs(buf, templog);
   fputc('\n', templog);
   fclose(templog);
   sprintf(cmdbuf, "cat ./logs/cs_reg.log >> ./logs/temp.log");
   system(cmdbuf);
   fopen("./logs/temp.log", "a");;
   fputc('\n', templog);
   fputc('\n', templog);
   *cmdbuf = 0;
   *buf = 0;

   strcat(buf, "[ChanServ Ownership Commands]:");
   fputs(buf, templog);
   fputc('\n', templog);
   fclose(templog);
   sprintf(cmdbuf, "cat ./logs/cs_own.log >> ./logs/temp.log");
   system(cmdbuf);
   fopen("./logs/temp.log", "a");;
   fputc('\n', templog);
   fputc('\n', templog);
   *cmdbuf = 0;
   *buf = 0;

   strcat(buf, "[ChanServ Expiry]:");
   fputs(buf, templog);
   fputc('\n', templog);
   fclose(templog);
   sprintf(cmdbuf, "cat ./logs/cs_exp.log >> ./logs/temp.log");
   system(cmdbuf);
   fopen("./logs/temp.log", "a");;
   fputc('\n', templog);
   fputc('\n', templog);
   *cmdbuf = 0;
   *buf = 0;

   strcat(buf, "[ChanServ Getpass Commands]:");
   fputs(buf, templog);
   fputc('\n', templog);
   fclose(templog);
   sprintf(cmdbuf, "cat ./logs/cs_gpd.log >> ./logs/temp.log");
   system(cmdbuf);
   fopen("./logs/temp.log", "a");;
   fputc('\n', templog);
   fputc('\n', templog);
   *cmdbuf = 0;
   *buf = 0;

   strcat(buf, "[ChanServ Flag Settings]:");
   fputs(buf, templog);
   fputc('\n', templog);
   fclose(templog);
   sprintf(cmdbuf, "cat ./logs/cs_flags.log >> ./logs/temp.log");
   system(cmdbuf);
   fopen("./logs/temp.log", "a");;
   fputc('\n', templog);
   fputc('\n', templog);
   *cmdbuf = 0;
   *buf = 0;

   strcat(buf, "[MemoServ Oper Commands]:");
   fputs(buf, templog);
   fputc('\n', templog);
   fclose(templog);
   sprintf(cmdbuf, "cat ./logs/ms_oper.log >> ./logs/temp.log");
   system(cmdbuf);
   fopen("./logs/temp.log", "a");;
   fputc('\n', templog);
   fputc('\n', templog);
   *cmdbuf = 0;
   *buf = 0;

   strcat(buf, "[MemoServ Expiry]:");
   fputs(buf, templog);
   fputc('\n', templog);
   fclose(templog);
   sprintf(cmdbuf, "cat ./logs/ms_exp.log >> ./logs/temp.log");
   system(cmdbuf);
   fopen("./logs/temp.log", "a");;
   fputc('\n', templog);
   fputc('\n', templog);
   *cmdbuf = 0;
   *buf = 0;

   fclose(templog);
   templog = NULL;

   if (ENABLE_LOGS != 1) {
       kill_logs(yday2, ymon2);
       if (uptime > 60)
            wallops(SERVER_NAME, "Sorted services logs");
       return;
   }
#ifdef SENDLOG   
  for (i = 0; i < MAX_SENDLOGS; i++) {
       if (sendlogs[i]) {
          if ((ni = findnick(sendlogs[i])) && ni->email) {
              sprintf(cmdbuf, "mail -s \"Services Logs\" %s < ./logs/temp.log",
                 ni->email);
              system(cmdbuf);
              *cmdbuf = 0;
          }
       }
   }

   for (i = 0, i2 = 0; i < MAX_SENDLOGS; i++) {
      if (sendlogs[i])
          i2++;
   }
#endif

   kill_logs(yday2, ymon2);

#ifdef SENDLOG
   if (uptime > 60)
     wallops(SERVER_NAME, "Sorted and E-Mailed services logs (%d)", i2);
#endif

}


static void kill_logs(const char *yday, const char *ymon)
{
   char cmdbuf[1024];
   char buf[128];

   *buf = 0;
   *cmdbuf = 0;

   strcat(buf, ymon);
   strcat(buf, "_");
   strcat(buf, yday);
   sprintf(cmdbuf, "mv ./logs/temp.log ./logs/%s", buf);
   system(cmdbuf);
//   system("rm ./logs/temp.log");
   *buf = 0;
   *cmdbuf = 0;
                 
   system("rm ./logs/os.log");
   system("rm ./logs/as.log");
   system("rm ./logs/rs.log");
   system("rm ./logs/ns_id.log");
   system("rm ./logs/ns_reg.log");
   system("rm ./logs/ns_own.log");
   system("rm ./logs/ns_exp.log");
   system("rm ./logs/ns_gpd.log");
   system("rm ./logs/ns_flags.log");
   system("rm ./logs/cs_id.log");
   system("rm ./logs/cs_reg.log");
   system("rm ./logs/cs_own.log");
   system("rm ./logs/cs_exp.log");
   system("rm ./logs/cs_gpd.log");
   system("rm ./logs/cs_flags.log");
   system("rm ./logs/ms_oper.log");
   system("rm ./logs/ms_exp.log");

   create_dummy_logs();

}

/*************************************************************************/
/*************************************************************************/
//                      BREAK LOG JUNK
/*************************************************************************/
/*************************************************************************/


void do_break_log(const char *service, const char *fmt,...)
{
    va_list args;
    time_t t;
    struct tm tm;
    char buf[256];

    va_start(args, fmt);
    time(&t);
    tm = *localtime(&t);
    strftime(buf, sizeof(buf)-1, "[%H:%M:%S] ", &tm);


   if (stricmp(service, "OS") == 0) {
        templog = fopen("./logs/os.log", "a");
        fputs(buf, templog);
        vfprintf(templog, fmt, args);
        fputc('\n', templog);
        fclose(templog);
        templog = NULL;

   } else if (stricmp(service, "AS") == 0) {
        templog = fopen("./logs/as.log", "a");
        fputs(buf, templog);
        vfprintf(templog, fmt, args);
        fputc('\n', templog);
        fclose(templog);
        templog = NULL;

   } else if (stricmp(service, "RS") == 0) {
        templog = fopen("./logs/rs.log", "a");
        fputs(buf, templog);
        vfprintf(templog, fmt, args);
        fputc('\n', templog);
        fclose(templog);
        templog = NULL;

   } else if (stricmp(service, "NS_I") == 0) {
            templog = fopen("./logs/ns_id.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);
            templog = NULL;

   } else if (stricmp(service, "NS_R") == 0) {
            templog = fopen("./logs/ns_reg.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);
            templog = NULL;

   } else if (stricmp(service, "NS_O") == 0) {
            templog = fopen("./logs/ns_own.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);
            templog = NULL;

   } else if (stricmp(service, "NS_X") == 0) {
            templog = fopen("./logs/ns_exp.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);
            templog = NULL;

   } else if (stricmp(service, "NS_G") == 0) {
            templog = fopen("./logs/ns_gpd.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);
            templog = NULL;

   } else if (stricmp(service, "NS_F") == 0) {
            templog = fopen("./logs/ns_flags.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);
            templog = NULL;


   } else if (stricmp(service, "CS_I") == 0) {
            templog = fopen("./logs/cs_id.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);
            templog = NULL;

   } else if (stricmp(service, "CS_R") == 0) {
            templog = fopen("./logs/cs_reg.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);
            templog = NULL;

   } else if (stricmp(service, "CS_X") == 0) {
            templog = fopen("./logs/cs_exp.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);
            templog = NULL;

   } else if (stricmp(service, "CS_G") == 0) {
            templog = fopen("./logs/cs_gpd.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);
            templog = NULL;

   } else if (stricmp(service, "CS_F") == 0) {
            templog = fopen("./logs/cs_flags.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);
            templog = NULL;

   } else if (stricmp(service, "CS_O") == 0) {
            templog = fopen("./logs/cs_own.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);
            templog = NULL;

   } else if (stricmp(service, "MS_L") == 0) {
            templog = fopen("./logs/ms_oper.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);
            templog = NULL;

   } else if (stricmp(service, "MS_X") == 0) {
            templog = fopen("./logs/ms_exp.log", "a");
            fputs(buf, templog);
            vfprintf(templog, fmt, args);
            fputc('\n', templog);
            fclose(templog);
            templog = NULL;

   }
}

