/* Routines for time-delayed actions.
 *
 * Auspice Services is copyright (c) 2000-2001 In Mean.
 *     E-mail: <inmean@auspice.org>
 * SirvNET Services is copyright (c) 1998-2000 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * Originally based on EsperNet Services(c) by Andy Church.
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 */


#include "../inc/services.h"
#include "../inc/timeout.h"

static Timeout *timeouts = NULL;

/*************************************************************************/

/* Check the timeout list for any pending actions. */

void check_timeouts(void)
{
    Timeout *to, *to2;
    CTime = time(NULL);

    if (debug)
	log("debug: Checking timeouts at %lu", CTime);

    to = timeouts;
    while (to) {
	if (CTime < to->timeout) {
	    to = to->next;
	    continue;
	}
	to->code(to);
	if (to->repeat) {
	    to = to->next;
	    continue;
	}
	to2 = to->next;
	if (to->next)
	    to->next->prev = to->prev;
	if (to->prev)
	    to->prev->next = to->next;
	else
	    timeouts = to->next;
	free(to);
	to = to2;
    }
}

/*************************************************************************/

/* Add a timeout to the list to be triggered in `delay' seconds.  If
 * `repeat' is nonzero, do not delete the timeout after it is triggered.
 * This must maintain the property that timeouts added from within a
 * timeout routine do not get checked during that run of the timeout list.
 */

Timeout *add_timeout(int delay, void (*code)(Timeout *), int repeat)
{
    Timeout *t = smalloc(sizeof(Timeout));
    t->settime = time(NULL);
    t->timeout = t->settime + delay;
    t->code = code; t->repeat = repeat;
    t->next = timeouts; t->prev = NULL;
    if (timeouts)
	timeouts->prev = t;
    timeouts = t;
    return t;
}

/*************************************************************************/

/* Remove a timeout from the list (if it's there). */

void del_timeout(Timeout *t)
{
    Timeout *ptr;

    for (ptr = timeouts; ptr; ptr = ptr->next) {
	if (ptr == t)
	    break;
    }
    if (!ptr)
	return;
    if (t->prev)
	t->prev->next = t->next;
    else
	timeouts = t->next;
    if (t->next)
	t->next->prev = t->prev;
    free(t);
}

/*************************************************************************/
